//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Sep 15 15:32:03 2021
//
//	==> Project name: five_point_suspension_python
//
//	==> Number of joints: 16
//
//	==> Function: F19 - External Forces
//
//	==> Git hash: e4323cc50f813318b5c64b3b53763c941a34ce32
//

#include <math.h> 

#include "mbs_data.h"

#include "mbs_project_interface.h"

// #include "mbs_extforces_xml_five_point_suspension_python.h"  // future development
// #include "mbs_extforces_hard_five_point_suspension_python.h" // future development
 
void mbs_extforces(double **frc, double **trq,
MbsData *s, double tsim)
{
#include "mbs_extforces_five_point_suspension_python.h"

double PxF1[4]; 
double RxF1[4][4]; 
double VxF1[4]; 
double OMxF1[4]; 
double AxF1[4]; 
double OMPxF1[4]; 
double *SWr1; 

double *q, *qd, *qdd;
double **dpt, **l;

frc = s->frc;
trq = s->trq;

q = s->q;
qd = s->qd;
qdd = s->qdd;

dpt = s->dpt;
l = s->l;
 
// Trigonometric functions

S10 = sin(q[10]);
C10 = cos(q[10]);
S11 = sin(q[11]);
C11 = cos(q[11]);
S12 = sin(q[12]);
C12 = cos(q[12]);
S13 = sin(q[13]);
C13 = cos(q[13]);
S14 = sin(q[14]);
C14 = cos(q[14]);
S15 = sin(q[15]);
C15 = cos(q[15]);
 
// Augmented Joint Position Vectors

 
// Sensor Kinematics

ROcp1_211 = C10*S11;
ROcp1_311 = S10*S11;
ROcp1_511 = C10*C11;
ROcp1_611 = S10*C11;
ROcp1_412 = -S11*C12;
ROcp1_512 = ROcp1_511*C12-S10*S12;
ROcp1_612 = ROcp1_611*C12+C10*S12;
ROcp1_712 = S11*S12;
ROcp1_812 = -ROcp1_511*S12-S10*C12;
ROcp1_912 = -ROcp1_611*S12+C10*C12;
ROcp1_113 = -ROcp1_712*S13+C11*C13;
ROcp1_213 = ROcp1_211*C13-ROcp1_812*S13;
ROcp1_313 = ROcp1_311*C13-ROcp1_912*S13;
ROcp1_713 = ROcp1_712*C13+C11*S13;
ROcp1_813 = ROcp1_211*S13+ROcp1_812*C13;
ROcp1_913 = ROcp1_311*S13+ROcp1_912*C13;
ROcp1_114 = ROcp1_113*C14+ROcp1_412*S14;
ROcp1_214 = ROcp1_213*C14+ROcp1_512*S14;
ROcp1_314 = ROcp1_313*C14+ROcp1_612*S14;
ROcp1_414 = -ROcp1_113*S14+ROcp1_412*C14;
ROcp1_514 = -ROcp1_213*S14+ROcp1_512*C14;
ROcp1_614 = -ROcp1_313*S14+ROcp1_612*C14;
ROcp1_115 = ROcp1_114*C15-ROcp1_713*S15;
ROcp1_215 = ROcp1_214*C15-ROcp1_813*S15;
ROcp1_315 = ROcp1_314*C15-ROcp1_913*S15;
ROcp1_715 = ROcp1_114*S15+ROcp1_713*C15;
ROcp1_815 = ROcp1_214*S15+ROcp1_813*C15;
ROcp1_915 = ROcp1_314*S15+ROcp1_913*C15;
POcp1_32 = q[1]+dpt[3][6];
OMcp1_23 = -qd[11]*S10;
OMcp1_33 = qd[11]*C10;
OPcp1_23 = -qd[10]*qd[11]*C10-qdd[11]*S10;
OPcp1_33 = -qd[10]*qd[11]*S10+qdd[11]*C10;
RLcp1_14 = -dpt[2][12]*S11;
RLcp1_24 = ROcp1_511*dpt[2][12];
RLcp1_34 = ROcp1_611*dpt[2][12];
POcp1_14 = RLcp1_14+dpt[1][6];
POcp1_24 = RLcp1_24+dpt[2][6];
POcp1_34 = POcp1_32+RLcp1_34;
OMcp1_14 = qd[10]+qd[12]*C11;
OMcp1_24 = OMcp1_23+qd[12]*ROcp1_211;
OMcp1_34 = OMcp1_33+qd[12]*ROcp1_311;
ORcp1_14 = OMcp1_23*RLcp1_34-OMcp1_33*RLcp1_24;
ORcp1_24 = -qd[10]*RLcp1_34+OMcp1_33*RLcp1_14;
ORcp1_34 = qd[10]*RLcp1_24-OMcp1_23*RLcp1_14;
VIcp1_34 = qd[1]+ORcp1_34;
OPcp1_14 = qdd[10]+qd[12]*(OMcp1_23*ROcp1_311-OMcp1_33*ROcp1_211)+qdd[12]*C11;
OPcp1_24 = OPcp1_23+qd[12]*(-qd[10]*ROcp1_311+OMcp1_33*C11)+qdd[12]*ROcp1_211;
OPcp1_34 = OPcp1_33+qd[12]*(qd[10]*ROcp1_211-OMcp1_23*C11)+qdd[12]*ROcp1_311;
ACcp1_14 = OMcp1_23*ORcp1_34-OMcp1_33*ORcp1_24+OPcp1_23*RLcp1_34-OPcp1_33*RLcp1_24;
ACcp1_24 = -qd[10]*ORcp1_34-qdd[10]*RLcp1_34+OMcp1_33*ORcp1_14+OPcp1_33*RLcp1_14;
ACcp1_34 = qdd[1]+qd[10]*ORcp1_24+qdd[10]*RLcp1_24-OMcp1_23*ORcp1_14-OPcp1_23*RLcp1_14;
OMcp1_15 = OMcp1_14+qd[13]*ROcp1_412;
OMcp1_25 = OMcp1_24+qd[13]*ROcp1_512;
OMcp1_35 = OMcp1_34+qd[13]*ROcp1_612;
OPcp1_15 = OPcp1_14+qd[13]*(OMcp1_24*ROcp1_612-OMcp1_34*ROcp1_512)+qdd[13]*ROcp1_412;
OPcp1_25 = OPcp1_24+qd[13]*(-OMcp1_14*ROcp1_612+OMcp1_34*ROcp1_412)+qdd[13]*ROcp1_512;
OPcp1_35 = OPcp1_34+qd[13]*(OMcp1_14*ROcp1_512-OMcp1_24*ROcp1_412)+qdd[13]*ROcp1_612;
OMcp1_16 = OMcp1_15+qd[14]*ROcp1_713;
OMcp1_26 = OMcp1_25+qd[14]*ROcp1_813;
OMcp1_36 = OMcp1_35+qd[14]*ROcp1_913;
OPcp1_16 = OPcp1_15+qd[14]*(OMcp1_25*ROcp1_913-OMcp1_35*ROcp1_813)+qdd[14]*ROcp1_713;
OPcp1_26 = OPcp1_25+qd[14]*(-OMcp1_15*ROcp1_913+OMcp1_35*ROcp1_713)+qdd[14]*ROcp1_813;
OPcp1_36 = OPcp1_35+qd[14]*(OMcp1_15*ROcp1_813-OMcp1_25*ROcp1_713)+qdd[14]*ROcp1_913;
RLcp1_17 = ROcp1_114*dpt[1][14]+ROcp1_414*dpt[2][14]+ROcp1_713*dpt[3][14];
RLcp1_27 = ROcp1_214*dpt[1][14]+ROcp1_514*dpt[2][14]+ROcp1_813*dpt[3][14];
RLcp1_37 = ROcp1_314*dpt[1][14]+ROcp1_614*dpt[2][14]+ROcp1_913*dpt[3][14];
POcp1_17 = POcp1_14+RLcp1_17;
POcp1_27 = POcp1_24+RLcp1_27;
POcp1_37 = POcp1_34+RLcp1_37;
OMcp1_17 = OMcp1_16+qd[15]*ROcp1_414;
OMcp1_27 = OMcp1_26+qd[15]*ROcp1_514;
OMcp1_37 = OMcp1_36+qd[15]*ROcp1_614;
ORcp1_17 = OMcp1_26*RLcp1_37-OMcp1_36*RLcp1_27;
ORcp1_27 = -OMcp1_16*RLcp1_37+OMcp1_36*RLcp1_17;
ORcp1_37 = OMcp1_16*RLcp1_27-OMcp1_26*RLcp1_17;
VIcp1_17 = ORcp1_14+ORcp1_17;
VIcp1_27 = ORcp1_24+ORcp1_27;
VIcp1_37 = ORcp1_37+VIcp1_34;
OPcp1_17 = OPcp1_16+qd[15]*(OMcp1_26*ROcp1_614-OMcp1_36*ROcp1_514)+qdd[15]*ROcp1_414;
OPcp1_27 = OPcp1_26+qd[15]*(-OMcp1_16*ROcp1_614+OMcp1_36*ROcp1_414)+qdd[15]*ROcp1_514;
OPcp1_37 = OPcp1_36+qd[15]*(OMcp1_16*ROcp1_514-OMcp1_26*ROcp1_414)+qdd[15]*ROcp1_614;
ACcp1_17 = ACcp1_14+OMcp1_26*ORcp1_37-OMcp1_36*ORcp1_27+OPcp1_26*RLcp1_37-OPcp1_36*RLcp1_27;
ACcp1_27 = ACcp1_24-OMcp1_16*ORcp1_37+OMcp1_36*ORcp1_17-OPcp1_16*RLcp1_37+OPcp1_36*RLcp1_17;
ACcp1_37 = ACcp1_34+OMcp1_16*ORcp1_27-OMcp1_26*ORcp1_17+OPcp1_16*RLcp1_27-OPcp1_26*RLcp1_17;
PxF1[1] = POcp1_17;
PxF1[2] = POcp1_27;
PxF1[3] = POcp1_37;
RxF1[1][1] = ROcp1_115;
RxF1[1][2] = ROcp1_215;
RxF1[1][3] = ROcp1_315;
RxF1[2][1] = ROcp1_414;
RxF1[2][2] = ROcp1_514;
RxF1[2][3] = ROcp1_614;
RxF1[3][1] = ROcp1_715;
RxF1[3][2] = ROcp1_815;
RxF1[3][3] = ROcp1_915;
VxF1[1] = VIcp1_17;
VxF1[2] = VIcp1_27;
VxF1[3] = VIcp1_37;
OMxF1[1] = OMcp1_17;
OMxF1[2] = OMcp1_27;
OMxF1[3] = OMcp1_37;
AxF1[1] = ACcp1_17;
AxF1[2] = ACcp1_27;
AxF1[3] = ACcp1_37;
OMPxF1[1] = OPcp1_17;
OMPxF1[2] = OPcp1_27;
OMPxF1[3] = OPcp1_37;
 
// Sensor Forces 

SWr1 = user_ExtForces(PxF1,RxF1,VxF1,OMxF1,AxF1,OMPxF1,s,tsim,1);
xfrc11 = RxF1[1][1]*SWr1[1]+RxF1[1][2]*SWr1[2]+RxF1[1][3]*SWr1[3];
xfrc21 = RxF1[2][1]*SWr1[1]+RxF1[2][2]*SWr1[2]+RxF1[2][3]*SWr1[3];
xfrc31 = RxF1[3][1]*SWr1[1]+RxF1[3][2]*SWr1[2]+RxF1[3][3]*SWr1[3];
xtrq11 = RxF1[1][1]*SWr1[4]+RxF1[1][2]*SWr1[5]+RxF1[1][3]*SWr1[6];
xtrq21 = RxF1[2][1]*SWr1[4]+RxF1[2][2]*SWr1[5]+RxF1[2][3]*SWr1[6];
xtrq31 = RxF1[3][1]*SWr1[4]+RxF1[3][2]*SWr1[5]+RxF1[3][3]*SWr1[6];
trqext_1_15_0 = xtrq11-xfrc21*SWr1[9]+xfrc31*SWr1[8];
trqext_2_15_0 = xtrq21+xfrc11*SWr1[9]-xfrc31*SWr1[7];
trqext_3_15_0 = xtrq31-xfrc11*SWr1[8]+xfrc21*SWr1[7];
 
// Symbolic model output

frc[1][15] = frc[1][15]+xfrc11;
frc[2][15] = frc[2][15]+xfrc21;
frc[3][15] = frc[3][15]+xfrc31;
trq[1][15] = trq[1][15]+trqext_1_15_0;
trq[2][15] = trq[2][15]+trqext_2_15_0;
trq[3][15] = trq[3][15]+trqext_3_15_0;

// Number of continuation lines = 0

}
